﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface INtfsDisableLastAccessUpdateStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class NtfsDisableLastAccessUpdateDefaultStrategy : ICorrespondenceOS, INtfsDisableLastAccessUpdateStrategy
    {
        public NtfsDisableLastAccessUpdateDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                          
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "NtfsDisableLastAccessUpdate";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\FileSystem");

            registryKey.SetValue(RegName,num,RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\FileSystem");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\FileSystem", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class NtfsDisableLastAccessUpdateController
    {
        public NtfsDisableLastAccessUpdateController(NtfsDisableLastAccessUpdate ntfsDisableLastAccessUpdate,
                                                         INtfsDisableLastAccessUpdateStrategy strategy)
        {
            NtfsDisableLastAccessUpdate = ntfsDisableLastAccessUpdate;
            Strategy = strategy;
        }

        public NtfsDisableLastAccessUpdate NtfsDisableLastAccessUpdate { get; set; }
        public INtfsDisableLastAccessUpdateStrategy Strategy { get; set; }

        public void Read()
        {
            NtfsDisableLastAccessUpdate.SetNtfsDisableLastAccessUpdateValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(NtfsDisableLastAccessUpdate.GetNtfsDisableLastAccessUpdateValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
